#version 430

layout (location = 0) in vec3 position;
layout (location = 1) in vec3 normal;
layout (location = 2) in vec2 texCoords;

layout (location = 3) in uvec4 firstBoneIDs;
layout (location = 4) in vec4 firstBoneWeights;
layout (location = 5) in int instanceID;

layout (location = 0) out smooth vec3 fragViewPos;
layout (location = 1) out smooth vec3 fragNormal;
layout (location = 2) out vec2 fragTexCoords;
layout (location = 3) out vec4 fragPosLightSpace;
layout (location = 4) flat out uvec3 fragInstanceID;
layout (location = 5) out float colorBrightness;



// matrices for drawing shit
uniform mat4 projection;
uniform mat4 lightSpaceMatrix;


uniform int modelID;
uniform int BoneCount; 

layout(binding = 0, rgba32f) uniform readonly restrict image2D inputTex;


mat4 getBone(uint boneID, uint instanceNumber){

	mat4 newMat;
	
		newMat[0] = vec4(imageLoad(inputTex, ivec2(20 + 4*boneID, instanceNumber)));
    newMat[1] = vec4(imageLoad(inputTex, ivec2(21 + 4*boneID, instanceNumber)));
    newMat[2] = vec4(imageLoad(inputTex, ivec2(22 + 4*boneID, instanceNumber)));
    newMat[3] = vec4(imageLoad(inputTex, ivec2(23 + 4*boneID, instanceNumber)));

	return newMat;

}


void main()

{
	int instanceNumber = gl_InstanceID;

	mat4 MVP;
	mat4 MV;
	mat4 lightSpaceModel;
		
	MVP[0] = vec4(imageLoad(inputTex, ivec2(0, instanceNumber)));
  MVP[1] = vec4(imageLoad(inputTex, ivec2(1, instanceNumber)));
  MVP[2] = vec4(imageLoad(inputTex, ivec2(2, instanceNumber)));
  MVP[3] = vec4(imageLoad(inputTex, ivec2(3, instanceNumber)));

	MV[0] = vec4(imageLoad(inputTex, ivec2(4, instanceNumber)));
  MV[1] = vec4(imageLoad(inputTex, ivec2(5, instanceNumber)));
  MV[2] = vec4(imageLoad(inputTex, ivec2(6, instanceNumber)));
  MV[3] = vec4(imageLoad(inputTex, ivec2(7, instanceNumber)));

	lightSpaceModel[0] = vec4(imageLoad(inputTex, ivec2(8, instanceNumber)));
  lightSpaceModel[1] = vec4(imageLoad(inputTex, ivec2(9, instanceNumber)));
  lightSpaceModel[2] = vec4(imageLoad(inputTex, ivec2(10, instanceNumber)));
  lightSpaceModel[3] = vec4(imageLoad(inputTex, ivec2(11, instanceNumber)));

	vec4 worldPos = vec4(position, 1.0);

	mat4 transformMatrix = mat4(1.0);
	
	if (BoneCount > 0){

	transformMatrix = firstBoneWeights.x * getBone(firstBoneIDs.x, instanceNumber);
	transformMatrix += firstBoneWeights.y * getBone(firstBoneIDs.y, instanceNumber);
	transformMatrix += firstBoneWeights.z * getBone(firstBoneIDs.z, instanceNumber);
	transformMatrix += firstBoneWeights.w * getBone(firstBoneIDs.w, instanceNumber);

	}

	worldPos = transformMatrix * worldPos;

	fragViewPos = (MV * worldPos).xyz;
	
	gl_Position = MVP * worldPos;

	fragTexCoords = texCoords;

  mat3 normalMatrix = transpose(inverse(mat3(MV * transformMatrix)));
  fragNormal = normalMatrix * normal;

	fragPosLightSpace = lightSpaceModel * worldPos;

	fragInstanceID.x = modelID; //this is modelID
	fragInstanceID.y = instanceID; // this is the instance ID
	fragInstanceID.z = uint(vec4(imageLoad(inputTex, ivec2(16, instanceNumber))).y); //playerID

	colorBrightness = vec4(imageLoad(inputTex, ivec2(16, instanceNumber))).x;

}